﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class AdminListReferenceRanges : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldRegistryName.Value = Helpers.GetConfigEntry("Registry");
        GridViewReferenceRanges.Caption = "";
    }

    public override string MenuItemName()
    {
        //return "List Users";
        return "REFERENCE RANGES";
    }

    public override string AppObjectCode()
    {
        return "REFERENCE RANGES";
    }

    public override string TopMenuName()
    {
        return "Administration";
    }

    protected void GridViewReferenceRanges_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Edit":
                var index1 = Convert.ToInt32(e.CommandArgument);
                GridViewReferenceRanges.SelectedIndex = index1;
                var id1 = Convert.ToInt32(GridViewReferenceRanges.SelectedValue);

                Response.Redirect("AdminEditReferenceRange.aspx?id={0}", id1);
                break;
        }

        GridViewReferenceRanges.SelectedIndex = -1;
    }
}
